using System;
using System.Collections.Generic;
using System.Linq;

using VIRP.EFR.BO;
using VIRP.EFR.DAL;
using VIRP.EFR.UTIL;

namespace VIRP.EFR.BLL
{
    public static partial class STD_ANALYSISMETHODManager
    {
        #region Fields
        #endregion

        #region Properties
        #endregion

        #region Methods

        public static STD_ANALYSISMETHOD GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 ID)
        {
            STD_ANALYSISMETHOD objReturn = null;
            STD_ANALYSISMETHODDB objDB = new STD_ANALYSISMETHODDB();

            objReturn = objDB.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, ID);

            return objReturn;
        }

        public static List<STD_ANALYSISMETHOD> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<STD_ANALYSISMETHOD> objReturn = null;
            STD_ANALYSISMETHODDB objDB = new STD_ANALYSISMETHODDB();

            objReturn = objDB.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);

            return objReturn;
        }

        public static List<KeyValuePair<int, string>> GetActiveOrderedAnalysisMethods(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            var db = new STD_ANALYSISMETHODDB();

            var methods = db.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID)
                .Where(m => m.INACTIVE_FLAG == false && m.BIOMONITORING_FLAG == true)
                .OrderBy(m => m.NAME)
                .Select(m => new KeyValuePair<int, string>(m.ID, m.NAME))
                .ToList();

            var comparer = new KeyValueComparer();

            methods.Sort(comparer);

            return methods;
        }

        public static Int32 Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, STD_ANALYSISMETHOD objSave)
        {
            Int32 objReturn = 0;
            STD_ANALYSISMETHODDB objDB = new STD_ANALYSISMETHODDB();

            objReturn = objDB.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);

            return objReturn;
        }

        public static Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 ID)
        {
            Boolean objReturn = false;
            STD_ANALYSISMETHODDB objDB = new STD_ANALYSISMETHODDB();

            objReturn = objDB.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, ID);

            return objReturn;
        }

        public static Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, STD_ANALYSISMETHOD objDelete)
        {
            return Delete(CURRENT_USER, CURRENT_REGISTRY_ID, objDelete.ID);
        }

        #endregion
    }
}
